<?php
// Require theme functions
require get_stylesheet_directory() . '/functions-theme.php';

// Customize your functions

/*后台滚动公告*/ 
include get_stylesheet_directory() . '/modules/gonggao.php';


if (_hui('start_classic_editor')) {
	//启用经典编辑器
    add_filter('use_block_editor_for_post', '__return_false');
}

if (_hui('disable_block_styles')) {
	//禁止前端加载样式文件
    remove_action( 'wp_enqueue_scripts', 'wp_common_block_scripts_and_styles' );
}

if (_hui('category_x')) {    
// 添加斜杠  分类页面添加"/"斜杠
function nice_trailingslashit($string, $type_of_url) {
	if ( $type_of_url != 'single' && $type_of_url != 'page' && $type_of_url != 'single_paged' )
		$string = trailingslashit($string);
	return $string;
}

	add_filter('user_trailingslashit', 'nice_trailingslashit', 10, 2);

function html_page_permalink() {
	global $wp_rewrite;
	if ( !strpos($wp_rewrite->get_page_permastruct(), '.html')){
		$wp_rewrite->page_structure = $wp_rewrite->page_structure . '.html';
	}
}	
}


// 显示全部设置
function all_settings_link() {
    add_options_page(__('All Settings'), __('All Settings'), 'administrator', 'options.php');
}
if (_hui('all_settings')) {   
add_action('admin_menu', 'all_settings_link');
}

if (_hui('revisions_no')) {   
// 禁用版本修订
add_filter( 'wp_revisions_to_keep', 'disable_wp_revisions_to_keep', 10, 2 );
}
function disable_wp_revisions_to_keep( $num, $post ) {
    return 0;
}





if (_hui('google_font')) {   
// 禁止后台加载谷歌字体
function wp_remove_open_sans_from_wp_core() {
    wp_deregister_style( 'open-sans' );
    wp_register_style( 'open-sans', false );
    wp_enqueue_style('open-sans','');
}
add_action( 'init', 'wp_remove_open_sans_from_wp_core' );
}

if (_hui('emoji')) {   
// 禁用emoji
 function disable_emojis() {
    remove_action( 'wp_print_styles', 'print_emoji_styles' );
 }
 add_action( 'init', 'disable_emojis' );
}

function remove_dns_prefetch( $hints, $relation_type ) {
    if ( 'dns-prefetch' === $relation_type ) {
        return array_diff( wp_dependencies_unique_hosts(), $hints );
    }
    return $hints;
}
add_filter( 'wp_resource_hints', 'remove_dns_prefetch', 10, 2 );


// 移除wp-json链接
if (_hui('wp_json')) { 
remove_action( 'wp_head', 'rest_output_link_wp_head', 10 );
remove_action( 'wp_head', 'wp_oembed_add_discovery_links', 10 );
}

// 隐藏后台标题中的“WordPress”
add_filter('admin_title', 'zm_custom_admin_title', 10, 2);
	function zm_custom_admin_title($admin_title, $title){
		return $title.' &lsaquo; '.get_bloginfo('name');
}
add_filter('login_title', 'zm_custom_login_title', 10, 2);
	function zm_custom_login_title($login_title, $title){
		return $title.' &lsaquo; '.get_bloginfo('name');
}

// 隐藏左上角WordPress标志
function hidden_admin_bar_remove() {
    global $wp_admin_bar;
    $wp_admin_bar->remove_menu('wp-logo');
}
add_action('wp_before_admin_bar_render', 'hidden_admin_bar_remove', 0);


// disable wp image sizes  禁用wp图像大小
function begin_customize_image_sizes( $sizes ){
    unset( $sizes[ 'thumbnail' ]);
    unset( $sizes[ 'medium' ]);
    unset( $sizes[ 'medium_large' ] );
    unset( $sizes[ 'large' ]);
    unset( $sizes[ 'full' ] );
    return $sizes;
}

// 打开缓冲区
add_action('init', 'do_output_buffer');
	function do_output_buffer() {
	ob_start();
}

if (_hui('pinglun_cn')) { 
//评论必须含有中文 
function refused_spam_comments( $comment_data ) {  
    $pattern = '/[一-龥]/u';  
if(!preg_match($pattern,$comment_data['comment_content'])) {  
    err('写点汉字吧，博主外语很捉急！You should type some Chinese word!');  
	}  
return( $comment_data );  
}  
add_filter('preprocess_comment','refused_spam_comments');
}

// 禁用REST API
if (_hui('disable_api')) {
	add_filter('rest_enabled', '_return_false');
	add_filter('rest_jsonp_enabled', '_return_false');
}


// WordPress 添加评论之星
 function get_author_class($comment_author_email,$user_id){
 global $wpdb;
 $author_count = count($wpdb->get_results(
 "SELECT comment_ID as author_count FROM $wpdb->comments WHERE comment_author_email = '$comment_author_email' "));
 // 如果不需要管理员显示VIP标签，就把下面一行的 // 去掉
 // $adminEmail = get_option('admin_email');if($comment_author_email ==$adminEmail) return;
 if($author_count>=1 && $author_count<20)
 echo '<a class="vip1" title="评论达人 LV.1"></a>';
 else if($author_count>=20 && $author_count<40)
 echo '<a class="vip2" title="评论达人 LV.2"></a>';
 else if($author_count>=40 && $author_count<80)
 echo '<a class="vip3" title="评论达人 LV.3"></a>';
 else if($author_count>=80 && $author_count<160)
 echo '<a class="vip4" title="评论达人 LV.4"></a>';
 else if($author_count>=160 && $author_count<320)
 echo '<a class="vip5" title="评论达人 LV.5"></a>';
 else if($author_count>=320 && $author_count<640)
 echo '<a class="vip6" title="评论达人 LV.6"></a>';
 else if($author_count>=640)
 echo '<a class="vip7" title="评论达人 LV.7"></a>';
}

require get_stylesheet_directory() . '/ua-show.php';


//显示网站运营版权时间 by Daniel Ting
function auto_copyright(){
    global $wpdb;
    $first = $wpdb->get_results(" 
    SELECT user_registered
    FROM   $wpdb->users  
    ORDER BY  ID ASC 
    LIMIT 0,1
    ");
    $output = '';
    $current = date('Y');
    if ($first) {
        $first = date('Y', strtotime($first[0]->user_registered));
        $copyright = "&copy; " . $first;
        if ($first != $current) {
            $copyright .= '-' . $current;
        }
        $output = $copyright;
    }
    echo $output;
}

//集成auto-highslide灯箱插件
add_filter('the_content', 'addhighslideclass_replace');
function addhighslideclass_replace ($content)
{   global $post;
	$pattern = "/<a(.*?)href=('|\")([^>]*).(bmp|gif|jpeg|jpg|png)('|\")(.*?)>(.*?)<\/a>/i";
    $replacement = '<a$1href=$2$3.$4$5 class="highslide-image" onclick="return hs.expand(this);"$6>$7</a>';
    $content = preg_replace($pattern, $replacement, $content);
    return $content;
}


/* 自动给页面的站外链接添加nofollow属性和新窗口打开 结束*/
function reply_to_read($atts, $content=null) {   
    extract(shortcode_atts(array("notice" => '<div style="text-align:center;border:1px dashed #FF9A9A;padding:8px;margin:10px auto;color:#FF6666;>
<span class="reply-to-read">温馨提示: 此处内容需要 <a href="#respond" title="评论本文">评论本文</a> 后 <a href="javascript:window.location.reload();" target="_self">刷新本页</a> 才能查看！</span></div>'), $atts));   
    $email = null;   
    $user_ID = (int) wp_get_current_user()->ID;   
    if ($user_ID > 0) {   
        $email = get_userdata($user_ID)->user_email;   
        //对博主直接显示内容   
        $admin_email = "316927639@cvps.top"; //博主Email   
        if ($email == $admin_email) {   
            return $content;   
        }   
    } else if (isset($_COOKIE['comment_author_email_' . COOKIEHASH])) {   
        $email = str_replace('%40', '@', $_COOKIE['comment_author_email_' . COOKIEHASH]);   
    } else {   
        return $notice;   
    }   
    if (empty($email)) {   
        return $notice;   
    }   
    global $wpdb;   
    $post_id = get_the_ID();   
    $query = "SELECT `comment_ID` FROM {$wpdb->comments} WHERE `comment_post_ID`={$post_id} and `comment_approved`='1' and `comment_author_email`='{$email}' LIMIT 1";   
    if ($wpdb->get_results($query)) {   
        return do_shortcode($content);   
    } else {   
        return $notice;   
    }   
}   

add_shortcode('reply', 'reply_to_read');


//添加评论可见快捷标签按钮
function appthemes_add_reply() {
    ?>
        <script type="text/javascript">
            if ( typeof QTags != 'undefined' ) {
                QTags.addButton( 'reply', '评论可见按钮', '[reply]','[/reply]' );
            } 
        </script>
    <?php 
    }
    add_action('admin_print_footer_scripts', 'appthemes_add_reply' );
    
    //部分内容输入密码可见
    function e_secret($atts, $content=null){
     extract(shortcode_atts(array('key'=>null), $atts));
     if(isset($_POST['e_secret_key']) && $_POST['e_secret_key']==$key){
     return '
    <div class="e-secret">'.$content.'</div>
    ';
     }
     elseif(isset($_POST['e_secret_key']) && $_POST['e_secret_key']!=$key){
            return '
                <script>
                    alert("密码错误，请仔细核对密码后重试！！！");
                    window.location.href="'.get_permalink().'";
                </script>
            ';
        
        }else{
     return '
    <form class="e-secret" action="'.get_permalink().'" method="post" name="e-secret"><label>请先加入QQ交流群获取密码后，再来查看加密内容吧~~~<br/>QQ群号：572614601</label><input type="password" name="e_secret_key" class="euc-y-i" maxlength="50"><input type="submit" class="euc-y-s" value="确定">
    <div class="euc-clear"></div>
    </form>
    ';
     }
    }
    add_shortcode('secret','e_secret');
    //密码可见快捷标签按钮
function appthemes_add_secret() {
    ?>
        <script type="text/javascript">
            if ( typeof QTags != 'undefined' ) {
                QTags.addButton( 'secret', '输入密码可见', '[secret key="572614601"]','[/secret]' );
            } 
        </script>
    <?php 
    }
    add_action('admin_print_footer_scripts', 'appthemes_add_secret' );
    
    //添加下载按钮
function appthemes_add_quicktags() {
    ?><script type="text/javascript">// <![CDATA[
    QTags.addButton( 'downs', '下载按钮', '<div class="sg-dl"><span class="sg-dl-span"><a href="','" target=_blank title="文件下载" rel=nofollow><button type="button" class="btn-download"><i class="fa fa-download"></i>&nbsp;本地下载</button></a></span></div>' );
    // ]]></script><?php } add_action('admin_print_footer_scripts', 'appthemes_add_quicktags' );


//文章摘要
function _new_get_excerpt($limit = 150, $after = '...') {
	$excerpt = get_the_excerpt();
	if (_new_strlen($excerpt) > $limit) {
		return _str_cut(strip_tags($excerpt), 0, $limit, $after);
	} else {
		return $excerpt;
	}
}

//新发表文章/修改文章时清空 recently_updated_posts 选项
function clear_rup_cache() {
    update_option('recently_updated_posts', ''); 
}
add_action('save_post', 'clear_rup_cache');



if (_hui('baidu_submit')) {
    // 百度主动推送
    if(!function_exists('Baidu_Submit')){
        function Baidu_Submit($post_ID) {
            $WEB_DOMAIN = get_option('home');
            if(get_post_meta($post_ID,'Baidusubmit',true) == 1) return;
            $url = get_permalink($post_ID);
            $api = 'http://data.zz.baidu.com/urls?site='.$WEB_DOMAIN.'&token='._hui('token_p');
            $request = new WP_Http;
            $result = $request->request( $api , array( 'method' => 'POST', 'body' => $url , 'headers' => 'Content-Type: text/plain') );
            $result = json_decode($result['body'],true);
            if (array_key_exists('success',$result)) {
                add_post_meta($post_ID, 'Baidusubmit', 1, true);
            }
        }
        add_action('publish_post', 'Baidu_Submit', 0);
    }
}


// 编辑_blank
function autoblank($text) {
	$return = str_replace('<a', '<a target="_blank"', $text);
	return $return;
}
add_filter('edit_post_link', 'autoblank');




// 评论加nofollow
function nofollow_comments_popup_link(){
	return ' rel="external nofollow"';
}


// 头部冗余代码
remove_action( 'wp_head', 'wp_generator' );
remove_action( 'wp_head', 'rsd_link' );
remove_action( 'wp_head', 'wlwmanifest_link' );
remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0 );
remove_action( 'wp_head', 'feed_links', 2 );
remove_action( 'wp_head', 'feed_links_extra', 3 );
remove_action( 'wp_head', 'wp_shortlink_wp_head', 10, 0 );


//数据库添加QQ号码字段  预留
add_action('wp_insert_comment','inlojv_sql_insert_qq_field',10,2);
function inlojv_sql_insert_qq_field($comment_ID,$commmentdata) {
	$qq = isset($_POST['new_field_qq']) ? $_POST['new_field_qq'] : false;  
	update_comment_meta($comment_ID,'new_field_qq',$qq); // new_field_qq 是表单name值，也是存储在数据库里的字段名字
}
// 后台评论中显示qq字段
add_filter( 'manage_edit-comments_columns', 'add_comments_columns' );
add_action( 'manage_comments_custom_column', 'output_comments_qq_columns', 10, 2 );
function add_comments_columns( $columns ){
    $columns[ 'new_field_qq' ] = __( 'QQ号' );        // 新增列名称
    return $columns;
}
function output_comments_qq_columns( $column_name, $comment_id ){
    switch( $column_name ) {
		case "new_field_qq" :
		 // 这是输出值，可以拿来在前端输出，这里已经在钩子manage_comments_custom_column上输出了
		echo get_comment_meta( $comment_id, 'new_field_qq', true );
		break;
	}
}

//添加@评论者功能
function comment_at( $comment_text, $comment = '') {
	if( $comment->comment_parent > 0) {
		$comment_text = '<span class="at">@<a href="#comment-' . $comment->comment_parent . '">'.get_comment_author( $comment->comment_parent ) . '</a></span> ' . $comment_text;
	}
	return $comment_text;
}
add_filter( 'comment_text' , 'comment_at', 20, 2);



// 历史今天
function begin_today(){
	global $wpdb;
	$post_year = get_the_time('Y');
	$post_month = get_the_time('m');
	$post_day = get_the_time('j');
	$sql = "select ID, year(post_date_gmt) as today_year, post_title, comment_count FROM 
			$wpdb->posts WHERE post_password = '' AND post_type = 'post' AND post_status = 'publish'
			AND year(post_date_gmt)!='$post_year' AND month(post_date_gmt)='$post_month' AND day(post_date_gmt)='$post_day'
			order by post_date_gmt DESC limit 8";
	$histtory_post = $wpdb->get_results($sql);
	if( $histtory_post ){
		foreach( $histtory_post as $post ){
			$today_year = $post->today_year;
			$today_post_title = $post->post_title;
			$today_permalink = get_permalink( $post->ID );
			// $today_comments = $post->comment_count;
			$today_post .= '<li><a href="'.$today_permalink.'" title="'.$today_post_title.'" target="_blank"><span>'.$today_year.'</span>'.$today_post_title.'</a></li>';
		}
	}
	if ( $today_post ){
		$result = '<div class="begin-today"><fieldset><legend><h5>历史上的今天</h5></legend><div class="today-date"><div class="today-m">'.get_the_date( 'F' ).'</div><div class="today-d">'.get_the_date( 'j' ).'</div></div><ul>'.$today_post.'</ul></fieldset></div>';
	}else{
		$result = '<div class="begin-today"><fieldset><legend><h5>历史上的今天</h5></legend><div class="today-date"><div class="today-m">'.get_the_date( 'F' ).'</div><div class="today-d">'.get_the_date( 'j' ).'</div></div><ul>哇哦~~~，历史上的今天没发表过文章哦</ul></fieldset></div>';		
	}
	return $result;
}

/*文章目录*/
function article_index($content) {
$matches = array();
$ul_li = '';
$r = "/<h4>([^<]+)<\/h4>/im";
if(preg_match_all($r, $content, $matches)) {
foreach($matches[1] as $num => $title) {
$content = str_replace($matches[0][$num], '<h4 class="title-'.$num.'">'.$title.'</h4>', $content);
$ul_li .= '<li><a href="#title-'.$num.'" title="'.$title.'">'.$title."</a></li>\n";
}
$content = "\n<div id=\"article-index\" class=\"article-index hidden-xs\">
<strong class=\"title\">文章目录</strong>
<ul id=\"index-ul\" class=\"index-ul\">\n" . $ul_li . "</ul>
</div>\n" . $content;
}
return $content;
}
if (_hui('index_c')) {
add_filter( "the_content", "article_index" );
}


 //添加背景按钮
add_theme_support( 'custom-background');


//图片添加alt属性
function img_alt( $imgalt ){
        global $post;
        $title = $post->post_title;
        $imgUrl = "<img\s[^>]*src=(\"??)([^\" >]*?)\\1[^>]*>";
        if(preg_match_all("/$imgUrl/siU",$imgalt,$matches,PREG_SET_ORDER)){
                if( !empty($matches) ){
                        for ($i=0; $i < count($matches); $i++){
                                $tag = $url = $matches[$i][0];
                                $judge = '/alt=/';
                                preg_match($judge,$tag,$match,PREG_OFFSET_CAPTURE);
                                if( count($match) < 1 )
                                $altURL = ' alt="'.$title.'" ';
                                $url = rtrim($url,'>');
                                $url .= $altURL.'>';
                                $imgalt = str_replace($tag,$url,$imgalt);
                        }
                }
        }
        return $imgalt;
}

add_filter( 'the_content','img_alt');


// 外链跳转
add_filter('the_content','wl_the_content_to',999);
function wl_the_content_to($content){
	preg_match_all('/href="(http.*?)"/',$content,$matches);
	if($matches){
		foreach($matches[1] as $val){
			 if( strpos($val,home_url())===false && !preg_match('/\.(jpg|jepg|png|ico|bmp|gif|tiff)/i',$val) && !preg_match('/(ed2k|thunder|Flashget|flashget|qqdl):\/\//i',$val))
			 $content=str_replace("href=\"$val\"", "rel=\"external nofollow\" target=\"_blank\" href=\"" .get_template_directory_uri(). "/go.php?url=" .base64_encode($val). "\"",$content);
 		}
 	}
	return $content;
}





// 评论者链接跳转
add_filter('get_comment_author_link', 'add_redirect_comment_link', 5);
add_filter('comment_text', 'add_redirect_comment_link', 99);
function add_redirect_comment_link() {
	$encodeurl = get_comment_author_url( $comment_ID );
	$url = get_template_directory_uri().'/go.php?url=' . base64_encode($encodeurl);
	$author = get_comment_author( $comment_ID );
	if ( empty( $encodeurl ) || 'http://' == $encodeurl )
		return $author;
	else
		return "<a href='$url' target='_blank' rel='external nofollow' class='url'>$author</a>";
}


// 网址跳转
function sites_nofollow($url) {
	$url = str_replace($url, get_template_directory_uri()."/go.php?url=".$url,$url);
	return $url;
}


// 外链nofollow
add_filter('the_content','wl_the_content',999);
function wl_the_content($content){
	preg_match_all('/href="(http.*?)"/',$content,$matches);
	if($matches){
		foreach($matches[1] as $val){
			 if( strpos($val,home_url())===false && !preg_match('/\.(jpg|jepg|png|ico|bmp|gif|tiff)/i',$val) && !preg_match('/(ed2k|thunder|Flashget|flashget|qqdl):\/\//i',$val))
			 $content=str_replace("href=\"$val\"", "rel=\"external nofollow\" target=\"_blank\" href=\"$val\" ",$content);
 		}
 	}
	return $content;
}


/*文章内容高亮提示框开始*/
/*青色警示文本框*/
function qgg_cyan($atts, $content=null){   
    return '<div id="tbc_cyan">'.$content.'</div>';   
}    
add_shortcode('qgg_cyan','qgg_cyan'); 
/*绿色警示文本框*/   
function qgg_green($atts, $content=null){   
    return '<div id="tbc_green">'.$content.'</div>';   
}    
add_shortcode('qgg_green','qgg_green');     
 /*黄色色警示文本框*/  
function qgg_yellow($atts, $content=null){   
    return '<div id="tbc_yellow">'.$content.'</div>';   
}    
add_shortcode('qgg_yellow','qgg_yellow'); 
 /*粉色警示文本框*/  
function qgg_pink($atts, $content=null){   
    return '<div id="tbc_pink">'.$content.'</div>';   
}    
add_shortcode('qgg_pink','qgg_pink');  
 /*灰色警示文本框*/  
function qgg_gray($atts, $content=null){   
    return '<div id="tbc_gray">'.$content.'</div>';   
}    
add_shortcode('qgg_gray','qgg_gray');   
/*文章内容高亮提示框完毕*/


/*添加彩色文本框快捷按钮*/
function appthemes_add_qgg_cyan() {
?>
    <script type="text/javascript">
    if ( typeof QTags != 'undefined' ) {
        QTags.addButton( 'qgg_cyan', '青色文本框', '[qgg_cyan]','[/qgg_cyan]' );
    } 
    </script>
<?php 
} 
add_action('admin_print_footer_scripts', 'appthemes_add_qgg_cyan' );

function appthemes_add_qgg_green() {
?>
    <script type="text/javascript">
    if ( typeof QTags != 'undefined' ) {
        QTags.addButton( 'qgg_green', '绿色文本框', '[qgg_green]','[/qgg_green]' );
    } 
    </script>
<?php 
} 
add_action('admin_print_footer_scripts', 'appthemes_add_qgg_green' );

function appthemes_add_qgg_yellow() {
?>
    <script type="text/javascript">
    if ( typeof QTags != 'undefined' ) {
        QTags.addButton( 'qgg_yellow', '黄色文本框', '[qgg_yellow]','[/qgg_yellow]' );
    } 
    </script>
<?php 
} 
add_action('admin_print_footer_scripts', 'appthemes_add_qgg_yellow' );

function appthemes_add_qgg_pink() {
?>
    <script type="text/javascript">
    if ( typeof QTags != 'undefined' ) {
        QTags.addButton( 'qgg_pink', '粉色文本框', '[qgg_pink]','[/qgg_pink]' );
    } 
    </script>
<?php 
} 
add_action('admin_print_footer_scripts', 'appthemes_add_qgg_pink' );

function appthemes_add_qgg_gray() {
?>
    <script type="text/javascript">
    if ( typeof QTags != 'undefined' ) {
        QTags.addButton( 'qgg_gray', '灰色文本框', '[qgg_gray]','[/qgg_gray]' );
    } 
    </script>
<?php 
} 
add_action('admin_print_footer_scripts', 'appthemes_add_qgg_gray' );

/*闪光按钮 开始 */
/*添加蓝色闪光按钮*/
function sg_blue($atts, $content = null) {
 extract(shortcode_atts(array(
 "href" => 'http://'
 ) , $atts));
 return '<a class="sgbtn_blue" href="' . $href . '" target="_blank" rel="nofollow">' . $content . '</a>';
}
add_shortcode('sgbtn_blue', 'sg_blue');
/*添加红色闪光按钮*/
function sg_red($atts, $content = null) {
 extract(shortcode_atts(array(
 "href" => 'http://'
 ) , $atts));
 return '<a class="sgbtn_red" href="' . $href . '" target="_blank" rel="nofollow">' . $content . '</a>';
}
add_shortcode('sgbtn_red', 'sg_red');
/*添加橙色闪光按钮*/
function sg_orange($atts, $content = null) {
 extract(shortcode_atts(array(
 "href" => 'http://'
 ) , $atts));
 return '<a class="sgbtn_orange" href="' . $href . '" target="_blank" rel="nofollow">' . $content . '</a>';
}
add_shortcode('sgbtn_orange', 'sg_orange');
/*添加绿色闪光按钮*/
function sg_lv($atts, $content = null) {
 extract(shortcode_atts(array(
 "href" => 'http://'
 ) , $atts));
 return '<a class="sgbtn_lv" href="' . $href . '" target="_blank" rel="nofollow">' . $content . '</a>';
}
add_shortcode('sgbtn_lv', 'sg_lv');
/*闪光按钮 结束*/

/*彩色按钮 开始*/
/*蓝色按钮*/
function toj($atts, $content=null) {
 extract(shortcode_atts(array("href" => 'http://'), $atts));
 return '<a class="bluebtn" href="' . $href . '" target="_blank" rel="nofollow">' .$content.'</a>';
}
add_shortcode('bb' , 'toj' );
/*黄色按钮*/
function tok($atts, $content=null) {
 extract(shortcode_atts(array("href" => 'http://'), $atts));
 return '<a class="yellowbtn" href="' . $href . '" target="_blank" rel="nofollow">' .$content.'</a>';
}
add_shortcode('yb' , 'tok' );
/*绿色按钮*/
function tol($atts, $content=null) {
 extract(shortcode_atts(array("href" => 'http://'), $atts));
 return '<a class="greenbtn" href="' . $href . '" target="_blank" rel="nofollow">' .$content.'</a>';
}
add_shortcode('gb' , 'tol' );

/*彩色按钮 结束*/

/*添加文本编辑自定义快捷标签按钮*/
 add_action('after_wp_tiny_mce', 'bolo_after_wp_tiny_mce');
 function bolo_after_wp_tiny_mce($mce_settings) {
 ?>
 <script type="text/javascript">
 QTags.addButton( 'sgbtn_blue', '蓝色闪光', "[sgbtn_blue href='']点击购买", "[/sgbtn_blue]" );
 QTags.addButton( 'sgbtn_red', '红色闪光', "[sgbtn_red href='']点击购买", "[/sgbtn_red]" );
 QTags.addButton( 'sgbtn_orange', '黄色闪光', "[sgbtn_orange href='']点击购买", "[/sgbtn_orange]" );
 QTags.addButton( 'sgbtn_lv', '绿色闪光', "[sgbtn_lv href='']点击购买", "[/sgbtn_lv]" );
 QTags.addButton( 'gb', '绿色按钮', "[gb href='']点击购买", "[/gb]" );
 QTags.addButton( 'bb', '蓝色按钮', "[bb href='']点击购买", "[/bb]" );
 QTags.addButton( 'yb', '黄色按钮', "[yb href='']点击购买", "[/yb]" );
 function bolo_QTnextpage_arg1() {
 }
 </script>
 <?php
 }
 /*添加文本编辑自定义快捷标签按钮 结束*/
 
 // 文章页添加展开收缩效果
function xcollapse($atts, $content = null){
	extract(shortcode_atts(array("title"=>""),$atts));
	return '<div style="margin: 0.5em 0;">
		    <div class="xControl">
			    <a href="javascript:void(0)" class="collapseButton xButton"><span class="xTitle">'.$title.'</span></a>
			    <div style="clear: both;"></div>
		    </div>
		<div class="xContent" style="display: none;">'.$content.'</div>
	</div>';
}
add_shortcode('collapse', 'xcollapse');

//添加展开/收缩快捷标签按钮
function appthemes_add_collapse() {
?>
    <script type="text/javascript">
        if ( typeof QTags != 'undefined' ) {
            QTags.addButton( 'collapse', '展开/收缩按钮', '[collapse title="点击展开 查看更多"]','[/collapse]' );
        } 
    </script>
<?php 
}
add_action('admin_print_footer_scripts', 'appthemes_add_collapse' );



// 图标
class be_font {
	function __construct(){
		add_filter( 'nav_menu_css_class', array( $this, 'nav_menu_css_class' ) );
		add_filter( 'walker_nav_menu_start_el', array( $this, 'walker_nav_menu_start_el' ), 10, 4 );
	}
	function nav_menu_css_class( $classes ){
		if( is_array( $classes ) ){
			$tmp_classes = preg_grep( '/^(be)(-\S+)?$/i', $classes );
			if( !empty( $tmp_classes ) ){
				$classes = array_values( array_diff( $classes, $tmp_classes ) );
			}
		}
		return $classes;
	}

	protected function replace_item( $item_output, $classes ){
		if( !in_array( 'be', $classes ) ){
			array_unshift( $classes, 'be' );
		}
		$before = true;
		$icon = '<i class="' . implode( ' ', $classes ) . '"></i>';
		preg_match( '/(<a.+>)(.+)(<\/a>)/i', $item_output, $matches );
		if( 4 === count( $matches ) ){
			$item_output = $matches[1];
			if( $before ){
				$item_output .= $icon . '<span class="font-text">' . $matches[2] . '</span>';
			} else {
				$item_output .= '<span class="font-text">' . $matches[2] . '</span>' . $icon;
			}
			$item_output .= $matches[3];
		}
		return $item_output;
	}

	function walker_nav_menu_start_el( $item_output, $item, $depth, $args ){
		if( is_array( $item->classes ) ){
			$classes = preg_grep( '/^(be)(-\S+)?$/i', $item->classes );
			if( !empty( $classes ) ){
				$item_output = $this->replace_item( $item_output, $classes );
			}
		}
		return $item_output;
	}
}
new be_font();



// 页面添加标签
class PTCFP{
	function __construct(){
	add_action( 'init', array( $this, 'taxonomies_for_pages' ) );
		if ( ! is_admin() ) {
			add_action( 'pre_get_posts', array( $this, 'tags_archives' ) );
		}
	}
	function taxonomies_for_pages() {
		register_taxonomy_for_object_type( 'post_tag', 'page' );
	}
	function tags_archives( $wp_query ) {
	if ( $wp_query->get( 'tag' ) )
		$wp_query->set( 'post_type', 'any' );
	}
}
$ptcfp = new PTCFP();


// 获取当前页面地址
function currenturl() {
	$current_url = home_url(add_query_arg(array()));
	if (is_single()) {
		$current_url = preg_replace('/(\/comment|page|#).*$/','',$current_url);
	} else {
		$current_url = preg_replace('/(comment|page|#).*$/','',$current_url);
	}
    echo $current_url;}
    

//说说功能
function my_custom_shuoshuo_init() { 
	$labels = array( 
	'name' => '说说',
	'singular_name' => '说说', 
	'all_items' => '所有说说',
	'add_new' => '发表说说', 
	'add_new_item' => '撰写新说说',
	'edit_item' => '编辑说说', 
	'new_item' => '新说说', 
	'view_item' => '查看说说', 
	'search_items' => '搜索说说', 
	'not_found' => '暂无说说', 
	'not_found_in_trash' => '没有已遗弃的说说', 
	'parent_item_colon' => '',
	'menu_name' => '说说'
	); 
	$args = array( 
	'labels' => $labels, 
	'public' => true, 
	'publicly_queryable' => true, 
	'show_ui' => true, 
	'show_in_menu' => true, 
	'query_var' => true, 
	'rewrite' => true, 
	'capability_type' => 'post', 
	'has_archive' => true, 
	'hierarchical' => false, 
	'menu_position' => null, 
	'supports' => array('title','editor','author') 
	); 
	register_post_type('shuoshuo',$args); 
}
add_action('init', 'my_custom_shuoshuo_init'); 


// sitemap_xml
if (_hui('sitemap_xml')) {  
    function cvps_sitemap_refresh() {
        require_once get_template_directory() . '/modules/sitemap-xml.php';
        $sitemap_xml = cvps_get_xml_sitemap();
        file_put_contents(ABSPATH.'sitemap.xml', $sitemap_xml);
    }
    if ( defined('ABSPATH') ) {
        add_action('publish_post', 'cvps_sitemap_refresh');
        add_action('save_post', 'cvps_sitemap_refresh');
        add_action('edit_post', 'cvps_sitemap_refresh');
        add_action('delete_post', 'cvps_sitemap_refresh');
    }
}